﻿using System.Collections.Generic;

using Ansys.Core.DataModel.ProjectSystem;
using Ansys.Core.DataModel;
using Ansys.Core.Commands;

namespace Ansys.ScratchAddin.Queries
{
    [Query("GetScratchComponentProperties")]
    public partial class GetScratchComponentPropertiesQuery : IQuery
    {
        //The component container's reference
        [Parameter]
        public DataContainerReference Container;

        //The Entity from which to get the component properties.
        [Parameter]
        public Output<DataReferenceSet> PropertiesEntities;

        #region IQuery Members

        public void Execute(IQueryContext context)
        {
            List<DataReference> propEntities = new List<DataReference>();
            using (context.ContainerReadLock(Container))
            {
                //Obtain the data reference and set the output value.
                propEntities.AddRange(context.Project.GetAllDataReferences(Container));
            }
            PropertiesEntities.Set(new DataReferenceSet(propEntities));
        }

        #endregion
    }
}