﻿using System;
using System.Collections.Generic;

using Ansys.Core.DataModel.ProjectSystem;
using Ansys.Core.DataModel;
using Ansys.Core.Commands;

using Ansys.ProjectSchematic.Queries;

namespace Ansys.ScratchAddin.Queries
{
    //This query returns the status of the component.
    [Query("GetScratchComponentStatus")]
    public partial class GetScratchComponentStatusQuery : IQuery
    {
        //The component's container reference
        [Parameter]
        public DataContainerReference Container;

        [Parameter(IsOptional = true)]
        public ComponentState DefaultState;

        //The current state of your component.
        [Parameter(IsOptional = true, IsReturnValue = true)]
        public Output<ComponentState> State;

        #region IQuery Members

        public void Execute(IQueryContext context)
        {
            Output.SetIfNotNull<ComponentState>(State, new ComponentState(DefaultState.State, ""));
        }

        #endregion
    }
}
