import clr
clr.AddReference("Ans.Core")
import Ansys.Core

handler = None
class SaveAsEventHandler(Ansys.Core.Events.IEventObserver, Ansys.Core.Events.IEventFilter):
    def Receive(self, eventInformation):
        ExtAPI.Log.WriteMessage('Save As Detected!')
        newDirName = eventInformation.GetData("ProjectFilesDirectory")
        if newDirName != None:
            ExtAPI.Log.WriteMessage('New directory = ' + newDirName)
    def IsMatch(self, eventInformation):
        retVal = False;
        if eventInformation.Name == Ansys.Core.EventNames.ProjectSaved:
            retVal = eventInformation.GetData("IsSaveAs")
        return retVal
def init(context):
    global handler
    handler = SaveAsEventHandler()
    Ansys.Core.Events.EventManager.FrameworkInstance.Subscribe(handler, handler)
def terminate(context):
    global handler
    if handler != None:
        Ansys.Core.Events.EventManager.FrameworkInstance.Unsubscribe(handler)