import System

import clr
clr.AddReference("Ans.Utilities")
import Ansys.Utilities

#convenience method to look up parameters based on a predetermined ID
def GetParameterByName(parameters, id):
    match = None
    for param in parameters:
        if param.ParameterName == id:
            match = param
            break
    return match

def update(task):
    container = task.InternalObject
    context = ExtAPI.DataModel.Context
    activeDir = container.GetActiveDirectory()
    extensionDir = ExtAPI.ExtensionManager.CurrentExtension.InstallDir
    exeName = "ExampleAddinExternalSolver.exe"
    solverPath = System.IO.Path.Combine(extensionDir, exeName)
    
    #get parameters owned by container
    
    params = None
    lock = context.ContainerReadLock(container)
    params = context.Project.GetDataReferencesByType(container, "ParameterAdapter")
    lock.Dispose()
    
    #isolate specific parameters
    
    inputParam = GetParameterByName(params, "Input")
    outputParam = GetParameterByName(params, "Output")
    
    #prep i/o file paths
    
    inputFileName = "input.txt"
    outputFileName = "output.txt"
    dpInputFile = System.IO.Path.Combine(activeDir, inputFileName)
    dpOutputFile = System.IO.Path.Combine(activeDir, outputFileName)
    
    #write input file
    
    if inputParam != None and outputParam != None:
        val = inputParam.Value    
        #write input file
        f = open(dpInputFile, "w")
        f.write('input='+val.ToString(System.Globalization.NumberFormatInfo.InvariantInfo))
        f.close()
    
    #run exe
    
    runInMono = Ansys.Utilities.ApplicationConfiguration.DefaultConfiguration.IsRuntimeMono
    monoPath = "mono"
    monoArgs = System.String.Format("{0} \"{1}\" \"{2}\"", solverPath, dpInputFile, dpOutputFile)
    info = None
    if runInMono:
        info = System.Diagnostics.ProcessStartInfo(monoPath, monoArgs)
    else:
        info = System.Diagnostics.ProcessStartInfo(solverPath, System.String.Format("\"{0}\" \"{1}\"", dpInputFile, dpOutputFile))
    info.CreateNoWindow = True
    info.WindowStyle = System.Diagnostics.ProcessWindowStyle.Minimized
    p = System.Diagnostics.Process.Start(info)
    p.WaitForExit()
    
    #read output file
    
    outValue = None
    f = open(dpOutputFile, "r")
    currLine = f.readline()
    while currLine != "":
        valuePair = currLine.split('=')
        outValue = System.Double.Parse(valuePair[1], System.Globalization.NumberFormatInfo.InvariantInfo)
        currLine = f.readline()
    f.close()
    
    #set output value
    
    if outValue == None:
        raise Exception("Error in update - no output value detected!")
    else:
        outputParam.Value = outValue
