import System
import clr
clr.AddReference("Ans.Core")
import Ansys.Core
clr.AddReference("Ans.UI")
import Ansys.UI
clr.AddReference("Ans.ProjectSchematic")
import Ansys.ProjectSchematic
clr.AddReference("Ans.UI.Toolkit")
clr.AddReference("Ans.UI.Toolkit.Base")
import Ansys.UI.Toolkit

def createContextMenu(context):
    ExtAPI.Log.WriteMessage("Registering custom context menu...")
    uiMgr = Ansys.UI.UIManager.Instance
    attributes = System.Collections.Generic.List[System.Attribute]()
    guiOpAttr = Ansys.UI.Attributes.GuiOperationAttribute("Set task color...")
    guiOpAttr.ImageName = "taskColorizer_rmb"
    attributes.Add(guiOpAttr)
    visOptions = Ansys.UI.Attributes.AttributeOptions.InitialVisibilityOff | Ansys.UI.Attributes.AttributeOptions.InitialEnablingOff | Ansys.UI.Attributes.AttributeOptions.UseCallback
    visAttr = Ansys.UI.Attributes.VisibilityAttribute(visOptions)
    attributes.Add(visAttr)
    menuEntryAttr = Ansys.UI.Attributes.ContextMenuEntryAttribute()
    attributes.Add(menuEntryAttr)
    defineContext = uiMgr.CreateGuiDefineContext()
    defineContext.RegisterOperation(SetTaskColorGuiOperation(), attributes)
    #must manually update the context menu manager by adding our new meta data to the Standard context menu
    uiMgrType = uiMgr.GetType()
    p = uiMgrType.GetProperty("GuiOperationRegistry", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
    guiOpRegistry = p.GetValue(uiMgr)
    menuMgr = uiMgr.ContextMenuManager
    menuMgrType = menuMgr.GetType()
    p = menuMgrType.GetProperty("Item", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
    args = System.Collections.Generic.List[System.Object]()
    args.Add("Standard")
    menu = p.GetValue(menuMgr, args.ToArray())
    menuType = menu.GetType()
    argTypes = System.Collections.Generic.List[System.Type]()
    argTypes.Add(clr.GetClrType(Ansys.UI.GuiOperationMetaData))
    addMethod = menuType.GetMethod("AddMenuItem", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic, None, System.Reflection.CallingConventions.HasThis, argTypes.ToArray(), None)
    args = System.Collections.Generic.List[System.Object]()
    args.Add("Set task color...")
    guiOpRegistryType = guiOpRegistry.GetType()
    getMethod = guiOpRegistryType.GetMethod("GetMetaDataForName", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
    metaData = getMethod.Invoke(guiOpRegistry, args.ToArray())
    #The UI only sets up images at start up.  We must do it manually for our entry...
    p = uiMgrType.GetProperty("ImageLibrary", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
    imageLib = p.GetValue(uiMgr)
    image = imageLib["taskColorizer_rmb"]
    metaDataType = metaData.GetType()
    p = metaDataType.GetProperty("Image", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
    p.SetValue(metaData, image)
    args = System.Collections.Generic.List[System.Object]()
    args.Add(metaData)
    #args.Add(System.Collections.Generic.List[System.String]())
    addMethod.Invoke(menu, args.ToArray())
def removeContextMenu(context):
    ExtAPI.Log.WriteMessage("Removing custom context menu...")
    uiMgr = Ansys.UI.UIManager.Instance
    uiMgrType = uiMgr.GetType()
    p = uiMgrType.GetProperty("GuiOperationRegistry", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
    guiOpRegistry = p.GetValue(uiMgr)
    guiOpRegistryType = guiOpRegistry.GetType()
    getMethod = guiOpRegistryType.GetMethod("GetMetaDataForName", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
    args = System.Collections.Generic.List[System.Object]()
    args.Add("Set task color...")
    metaData = getMethod.Invoke(guiOpRegistry, args.ToArray())
    menuMgr = uiMgr.ContextMenuManager
    menuMgrType = menuMgr.GetType()
    p = menuMgrType.GetProperty("Item", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
    args = System.Collections.Generic.List[System.Object]()
    args.Add("Standard")
    menu = p.GetValue(menuMgr, args.ToArray())
    menuType = menu.GetType()
    removeMethod = menuType.GetMethod("RemoveMenuOrMenuItem", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
    args = System.Collections.Generic.List[System.Object]()
    args.Add(metaData)
    args.Add(None)
    removeMethod.Invoke(menu, args.ToArray())
    f = guiOpRegistryType.GetField("_registeredOperations", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
    registeredOps = f.GetValue(guiOpRegistry);
    registeredOps.Remove(metaData)
    f.SetValue(guiOpRegistry, registeredOps)
    f = guiOpRegistryType.GetField("_operationIndex", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
    opIndex = f.GetValue(guiOpRegistry);
    metaDataType = metaData.GetType()
    p = metaDataType.GetProperty("OpType", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
    opType = p.GetValue(metaData)
    opIndex.Remove(opType)
    f.SetValue(guiOpRegistry, opIndex)
class SetTaskColorGuiOperation(Ansys.UI.Interfaces.IGuiOperation):
    def Invoke(self, context):
        selection = context.View.GetSingleUISelection[Ansys.Core.DataModel.ProjectSystem.DataContainerReference]()
        if selection == None:
            uiMgr = Ansys.UI.UIManager.Instance
            workspace = uiMgr.GetActiveWorkspace()
            view = workspace.GetView("ProjectSchematic")
            selection = view.GetSingleUISelection[Ansys.Core.DataModel.ProjectSystem.DataContainerReference]()
        d = Ansys.UI.Toolkit.ColorDialog()
        res = d.ShowDialog()
        color = None
        if res == Ansys.UI.Toolkit.DialogResult.OK:
            color = d.SelectedColor
        if color != None:
            guid = selection.Name
            dict = {}
            if ExtAPI.Extension.Attributes.Contains("Colors"):
                dict = ExtAPI.Extension.Attributes["Colors"]
            if not dict.ContainsKey(guid):
                dict.Add(guid, [color.Red, color.Green, color.Blue])
            else:
                dict[guid] = [color.Red, color.Green, color.Blue]
            ExtAPI.Extension.Attributes.SetValue("Colors", dict)
        context.View.Refresh()
    def GuiItemCallBack(self, context):
        context.Visible = False
        context.Enabled = False
        selection = context.View.GetSingleUISelection[Ansys.Core.DataModel.ProjectSystem.DataContainerReference]()
        if selection != None:
            context.Visible = True
            context.Enabled = True
def applyColor(task, args):
    if Ansys.UI.UIManager.IsRunningInteractively:
        uiMgr = Ansys.UI.UIManager.Instance
        workspace = uiMgr.GetActiveWorkspace()
        view = workspace.GetView("ProjectSchematic")
        viewType = view.GetType()
        rulesProp = viewType.GetProperty("Rules", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
        rules = rulesProp.GetValue(view)
        rulesType = rules.GetType()
        cellBackColorsField = rulesType.GetField("_cellBackground", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic)
        cellBackgroundColors = cellBackColorsField.GetValue(rules)
        component = task.InternalObject
        containerReference = task.Container
        guid = containerReference.Name
        dict = {}
        if ExtAPI.Extension.Attributes.Contains("Colors"):
            dict = ExtAPI.Extension.Attributes["Colors"]
        if dict.ContainsKey(guid):
            rgb = dict[guid]
            cellBackgroundColors[component] = Ansys.Utilities.Color(rgb[0], rgb[1], rgb[2])